/*
 * Decompiled with CFR 0.152.
 */
package beaver.spec;

import beaver.Symbol;
import beaver.spec.GrammarSymbol;
import beaver.spec.NonTerminal;
import beaver.spec.Terminal;
import java.util.Comparator;

public class Production {
    static final Comparator NUM_TERM_CMP = new Comparator(){

        public int compare(Object o1, Object o2) {
            return ((Production)o2).rhs.n_term - ((Production)o1).rhs.n_term;
        }
    };
    static final Comparator NUM_NONTERM_CMP = new Comparator(){

        public int compare(Object o1, Object o2) {
            return ((Production)o2).rhs.n_nonterm - ((Production)o1).rhs.n_nonterm;
        }
    };
    private static final Terminal DEFAULT_PRECEDENCE_SYMBOL = new Terminal("DEFAULT_PRECEDENCE", -1, Terminal.Associativity.NONE);
    public Production next_definition;
    public final int id;
    public final NonTerminal lhs;
    public final RHS rhs;
    public final Terminal prec_sym;
    public String code;
    public int start_pos;
    public int end_pos;
    public boolean is_reducible;

    Production(int id, NonTerminal lhs, RHS rhs, Terminal prec_sym) {
        this.id = id;
        this.lhs = lhs;
        this.rhs = rhs;
        if (prec_sym == null) {
            prec_sym = DEFAULT_PRECEDENCE_SYMBOL;
            int i = rhs.items.length - 1;
            while (i >= 0) {
                if (rhs.items[i].symbol instanceof Terminal) {
                    Terminal term = (Terminal)rhs.items[i].symbol;
                    if (term.prec > 0) {
                        prec_sym = term;
                        break;
                    }
                }
                --i;
            }
        }
        this.prec_sym = prec_sym;
        if (rhs.items.length == 0) {
            lhs.is_nullable = true;
        }
        lhs.definitions.add(this);
    }

    Production(int id, NonTerminal lhs, RHS rhs) {
        this(id, lhs, rhs, null);
    }

    boolean isNullable() {
        if (this.rhs.first_term != null) {
            return false;
        }
        int i = 0;
        while (i < this.rhs.items.length) {
            if (!((NonTerminal)this.rhs.items[i].symbol).is_nullable) {
                return false;
            }
            ++i;
        }
        return true;
    }

    void startFirstSet() {
        int i = 0;
        while (i < this.rhs.items.length) {
            if (this.rhs.items[i].symbol instanceof Terminal) {
                this.lhs.first_set.add(this.rhs.items[i].symbol.id);
                break;
            }
            NonTerminal rhs_nt = (NonTerminal)this.rhs.items[i].symbol;
            if (rhs_nt != this.lhs && rhs_nt.first_set != null) {
                this.lhs.first_set.add(rhs_nt.first_set);
            }
            if (!rhs_nt.is_nullable) break;
            ++i;
        }
    }

    boolean extendFirstSet() {
        boolean more_added = false;
        int i = 0;
        while (i < this.rhs.items.length) {
            if (this.rhs.items[i].symbol instanceof Terminal) break;
            NonTerminal rhs_nt = (NonTerminal)this.rhs.items[i].symbol;
            if (rhs_nt != this.lhs && rhs_nt.first_set != null && this.lhs.first_set.add(rhs_nt.first_set)) {
                more_added = true;
            }
            if (!rhs_nt.is_nullable) break;
            ++i;
        }
        return more_added;
    }

    public int getFirstLine() {
        return Symbol.getLine(this.start_pos);
    }

    public String toString() {
        return new StringBuffer(100).append(this.lhs).append(" = ").append(this.rhs).toString();
    }

    public static class List {
        private Production first;
        private Production last;
        private int size;

        public void add(Production rule) {
            this.last = this.last == null ? (this.first = rule) : (this.last.next_definition = rule);
            ++this.size;
        }

        public Production start() {
            return this.first;
        }

        public int size() {
            return this.size;
        }
    }

    public static class RHS {
        public static final Item[] NONE = new Item[0];
        public final Item[] items;
        Item first_term;
        int n_term;
        int n_nonterm;

        RHS() {
            this.items = NONE;
        }

        RHS(Item[] items) {
            this.items = items;
            int i = 0;
            while (i < items.length) {
                Item rhs_item = items[i];
                if (rhs_item.symbol instanceof Terminal) {
                    if (this.first_term == null) {
                        this.first_term = rhs_item;
                    }
                    ++this.n_term;
                } else {
                    ++this.n_nonterm;
                }
                ++i;
            }
        }

        RHS(GrammarSymbol sym) {
            this(new Item[]{new Item(sym)});
        }

        RHS(GrammarSymbol symA, GrammarSymbol symB) {
            this(new Item[]{new Item(symA), new Item(symB)});
        }

        public Item start() {
            return this.items.length > 0 ? this.items[0] : null;
        }

        public Item end() {
            return this.items.length > 0 ? this.items[this.items.length - 1] : null;
        }

        public int size() {
            return this.items.length;
        }

        public String toString() {
            if (this.items.length == 0) {
                return "";
            }
            if (this.items.length == 1) {
                return this.items[0].toString();
            }
            int len = -1;
            int i = 0;
            while (i < this.items.length) {
                len += 1 + this.items[i].symbol.name.length();
                if (this.items[i].alias != null) {
                    len += 1 + this.items[i].alias.length();
                }
                ++i;
            }
            StringBuffer str = new StringBuffer(len);
            this.items[0].appendTo(str);
            int i2 = 1;
            while (i2 < this.items.length) {
                str.append(' ');
                this.items[i2].appendTo(str);
                ++i2;
            }
            return str.toString();
        }

        public static class Item {
            public final GrammarSymbol symbol;
            public final String alias;

            Item(GrammarSymbol sym) {
                this.symbol = sym;
                this.alias = null;
            }

            Item(GrammarSymbol sym, String alias) {
                this.symbol = sym;
                this.alias = alias;
            }

            public String toString() {
                return this.alias == null ? this.symbol.name : new StringBuffer(this.symbol.name.length() + 1 + this.alias.length()).append(this.symbol.name).append('.').append(this.alias).toString();
            }

            void appendTo(StringBuffer str) {
                str.append(this.symbol.name);
                if (this.alias != null) {
                    str.append('.').append(this.alias);
                }
            }
        }
    }
}

